//save as PNG
//convert to 8-bit grayscale (256 grays) in GraphicConverter
//Best way to get hills: 
// 1. make a white solid area of hill on a transparent layer and select it
// 2. apply Fade to Outline Script, fade from 0 to 100, clear unselected mask area
// 3. Invert color of layer
// 4. Apply layer mask
// can also adjust brightness and contrast of layer
//
//for depression
//1. make a white slid area on a transparent layer and select it
//2. apply fade to outline script, fade from 100 to 0, clear unseleced mask area
//3. switch off of mask and invert color of layer
//4. apply layer mask

#declare landHeight = 14;
#declare simple_radius=21*hex_diag/2;

#include "grassfield.inc"

//ground
#declare Sand_Texture = texture {
	pigment {
		color Yellow
	}
}
#declare Rock_Texture = texture {
	pigment {
		color Tan
	}
}

#declare Land_Texture = texture {
	gradient y
	texture_map {
		[0.0 Sand_Texture ]
		[0.5 Sand_Texture ]
		[0.85 Rock_Texture]
		[1.0 Rock_Texture ]
	}
	turbulence .20
	scale <1, landHeight*1.01, 1>
}

#declare River_Texture = texture {
	pigment {
		color Blue filter .5
	}
	normal {
		bumps 3
		turbulence <.4,.1,0>
		scale <2,1,2>
		scale .25
	}
	finish {
		reflection .7
		specular 0.4
		roughness 0.2
	}
}


//land
#declare land = height_field {
	png "Vale Ground.png"
	smooth
	translate <-.5, 0, -.5>
	scale <simple_radius*2, landHeight, simple_radius*2>
}

#declare river = height_field {
	png "river.png"
	translate <-.5, 0, -.5>
	scale <simple_radius*2, landHeight*.24, simple_radius*2>
	texture { River_Texture }
	rotate <0, 0, .75>
}

#declare caveEntry = <0, simple_radius, simple_radius-1>;
#declare caveEntry = trace(land, caveEntry, <0, -1, 0>, nvector);	
#declare caveWidth = 6*feet;
#declare caveRadius = caveWidth/2;
#declare caveHeight = 7*feet;
#declare caveLength = 100;
#declare caveExtension = -10;

#declare cave = intersection {
	cylinder {
		<0, 0, caveExtension>, <0, 0, caveLength>, caveRadius
	}
	box {
		<-caveRadius, 0, caveExtension>, <caveRadius, caveRadius, caveLength>
	}
	scale <1, caveHeight/caveRadius, 1>
	translate caveEntry
}

#declare land = difference {
	object { land }
	object { cave }
	texture { Land_Texture }
}

#if (viewType = overView)
	#declare landExtent = cylinder {
		<0, -simple_radius, 0>, <0, simple_radius, 0>, simple_radius
	}
	
	#declare land = intersection {
		object { land }
		object { landExtent }
	}
	
	#declare river = intersection {
		object { river }
		object { landExtent }
	}
#end

#declare land = union {
	object { land }
	object { river }
	//grass
	#ifdef (grassField)
			object { grassField }
	#end
	
}


